<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSystemParamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('system_params', function (Blueprint $table) {
            $table->id();
            $table->text('tap_app_secret_key_sandbox')->nullable();
            $table->text('tap_secret_key_sandbox')->nullable();
            $table->text('tap_public_key_sandbox')->nullable();
            $table->text('tap_app_secret_key_live')->nullable();
            $table->text('tap_secret_key_live')->nullable();
            $table->text('tap_public_key_live')->nullable();
            $table->text('google_maps_key')->nullable();
            $table->text('website_main_bg')->nullable();
            $table->enum('tap_mode', ['sandbox', 'live'])->default('sandbox');

            $table->text('shutdown_message_en')->nullable();
            $table->text('shutdown_message_ar')->nullable();
            $table->timestamp('shutdown_date')->nullable();
            $table->boolean('shutdown_activated')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_params');
    }
}
