<?php

namespace Database\Seeders;


use Illuminate\Database\Seeder;
use Khsing\World\Models\Country;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Country::query()
            ->where(function ($query) {
                foreach (config('app.supported_countries') as $country) {
                    $query->orWhere('name', '=', $country);
                }
            })
            ->update(['active' => true]);
    }
}
