<?php

use App\Http\Controllers\API\AboutController;
use App\Http\Controllers\API\AccountRecoveryController;
use App\Http\Controllers\API\AccountVerificationController;
use App\Http\Controllers\API\AddressController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\BrandController;
use App\Http\Controllers\API\ContactController;
use App\Http\Controllers\API\CountryController;
use App\Http\Controllers\API\CouponController;
use App\Http\Controllers\API\DeliveryOptionController;
use App\Http\Controllers\API\FaqController;
use App\Http\Controllers\API\NotificationController;
use App\Http\Controllers\API\OrderController;
use App\Http\Controllers\API\PaymentController;
use App\Http\Controllers\API\PaymentReportController;
use App\Http\Controllers\API\PlatformSettingController;
use App\Http\Controllers\API\ProductCategoryController;
use App\Http\Controllers\API\ProductController;
use App\Http\Controllers\API\PublicController;
use App\Http\Controllers\API\ReviewController;
use App\Http\Controllers\API\SellerController;
use App\Http\Controllers\API\SystemParamController;
use App\Http\Controllers\API\UserController;
use App\Models\AppPreference;
use Illuminate\Support\Facades\Route;

Route::get('test', function () {
    $orders = \App\Models\Order::withTrashed()->groupBy('number')
        ->selectRaw('number, count(*) as count')
        ->having('count','>',1)
        ->get();
    return $orders;
    /*$users = \App\Models\User::withTrashed()->get();
    foreach ($users as $user)
    {
        if ($user->appPreference == null)
        {
            AppPreference::query()->create([
                'user_id' => $user->id
            ]);
            var_dump($user->id);
        }
    }*/
});
Route::get('testSMS', [PublicController::class, 'test']);
Route::get('timezone', [PublicController::class, 'timezone']);
Route::get('currency', [PublicController::class, 'currency']);
Route::get('unauthorized', [PublicController::class, 'unauthorized']);

Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::post('logout', [AuthController::class, 'logout']);
Route::post('resetPassword', [AuthController::class, 'resetPassword']);
Route::get('verifyAccount', [AccountVerificationController::class, 'verifyAccount']);
Route::post('verifyAccountByCode', [AccountVerificationController::class, 'verifyAccountByCode']);
Route::post('resendVerification', [AccountVerificationController::class, 'resendVerification']);
Route::post('forgotPassword', [AccountRecoveryController::class, 'forgotPassword']);
Route::get('resetForgotPassword', [AccountRecoveryController::class, 'resetForgotPassword']);
Route::post('resetForgotPassword', [AccountRecoveryController::class, 'resetForgotPasswordByCode']);

Route::get('user', [UserController::class, 'show']);
Route::put('user', [UserController::class, 'update']);
Route::patch('user', [UserController::class, 'update']);
Route::delete('user',[UserController::class,'destroy']);

Route::get('about', [AboutController::class, 'index']);

Route::get('brand', [BrandController::class, 'index']);

Route::resource('country', CountryController::class)
    ->only(['index', 'show'])->parameters(['country' => 'id']);

Route::post('contact', [ContactController::class, 'store']);

Route::get('coupon', [CouponController::class, 'index']);
Route::get('couponByCode/{code}', [CouponController::class, 'getByCode']);

Route::get('faq', [FaqController::class, 'index']);

Route::get('productCategory', [ProductCategoryController::class, 'index']);

Route::get('notification', [NotificationController::class, 'index']);
Route::get('notificationStatus', [NotificationController::class, 'status']);
Route::put('notification', [NotificationController::class, 'update']);
Route::delete('notification/{id}', [NotificationController::class, 'destroy']);
Route::get('platformSettings', PlatformSettingController::class);

Route::get('seller', [SellerController::class, 'index']);

Route::resource('address', AddressController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['address' => 'id']);

Route::resource('order', OrderController::class)
    ->only(['index', 'show'])->parameters(['address' => 'id']);

Route::post('checkout', [OrderController::class, 'checkout']);
Route::post('order/postCallback', [OrderController::class, 'postProcess']);
Route::post('paymentReport', [PaymentReportController::class, 'store']);

Route::resource('product', ProductController::class)
    ->only(['index', 'show'])->parameters(['product' => 'id']);
Route::get('topRankingProducts', [ProductController::class, 'topRating']);
Route::get('todayDeals', [ProductController::class, 'todayDeals']);
Route::get('favoriteProducts', [ProductController::class, 'favorites']);
Route::post('toggleProductFavorite/{id}', [ProductController::class, 'toggleProductLike']);
Route::get('deliveryOption', [DeliveryOptionController::class, 'index']);
Route::get('paymentMethod', [PaymentController::class, 'index']);

Route::resource('review', ReviewController::class)
    ->only(['show', 'store', 'update', 'delete'])->parameters(['review' => 'id']);

Route::resource('systemParam', SystemParamController::class)
    ->only(['index'])->parameters(['systemParam' => 'id']);

Route::get('mainSliders',[\App\Http\Controllers\API\SliderController::class,'indexMain']);
Route::get('secSliders',[\App\Http\Controllers\API\SliderController::class,'indexSecondary']);
Route::get('slider/{slider}',[\App\Http\Controllers\API\SliderController::class,'show']);
